﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityStandardAssets.Characters.ThirdPerson;

//	Summary
//		* Player의 이동에 따른 발자국 animation event를 처리한다.

namespace GameUtility
{
	/*
		Foot step.
 	*/
	public class FootStep : MonoBehaviour
	{

		public AudioSource FootStepSource;
		public AudioClip[] FootStepClip;
		public AudioClip[] LandingClip;

		// Use this for initialization
		void Start ()
		{
		
		}

		// Update is called once per frame
		void Update ()
		{
		
		}

		/*
			착지시
	 	*/
		public void Landing ()
		{
			// if (FootStepSource.isPlaying == true) {
			// 	return;
			// }
		
			AudioClip clip = null;
//			float maxVolume	= 1.0f;
//			float pitch = 1.0f;
		
			clip = LandingClip [Random.Range (0, LandingClip.Length)];
//			maxVolume	= Random.Range (0.8f, 1.0f);

			FootStepSource.PlayOneShot (clip);
		}

		/*
			왼쪽 발
	 	*/
		public void LeftStep ()
		{
			Step ();
		}

		/*
			오른쪽 발
	 	*/
		public void RightStep ()
		{
			Step ();
		}

		/*
			step시 발자국 소리를 재생한다.
	 	*/
		void Step ()
		{
			AudioClip clip = null;
//		float maxVolume	= 1.0f;
//		float pitch		= 1.0f;
		
			if (GetComponent<SimpleCharacterControl> ().IsGrounded () == true) {
				clip = FootStepClip [0];
				// maxVolume	= Random.Range(0.3f, 0.7f);
				// pitch		= Random.Range(0.2f, 0.9f);
			}

			if (clip != null) {
				FootStepSource.clip = clip;
				// FootStepSource.volume	= maxVolume;
				// FootStepSource.pitch	= pitch;
				FootStepSource.PlayOneShot (clip);
			}
		}
	}
}